﻿USE [CC_REFDOC]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_Nature'  )
    BEGIN
CREATE TABLE [App].[NVCC_Nature](
	[NatureId] [int] IDENTITY(1,1) NOT NULL,
	[NatureName] [varchar](50) NOT NULL,
PRIMARY KEY (NatureId),
CONSTRAINT  AK_NatureName UNIQUE([NatureName]) 
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_Disclosure'  )
    BEGIN
CREATE TABLE [App].[NVCC_Disclosure](
	[DisclosureId] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [varchar](50) NOT NULL,
        [PatientICN] [varchar](50) NOT NULL,
	[DateTimeOfDisclosure] [datetime2](2) NOT NULL,
	[ProviderNameOrGroup] [varchar](50) NOT NULL,
	[ProviderStreetAddress1] [varchar](100) NOT NULL,
        [ProviderStreetAddress2] [varchar](100) NULL,
        [ProviderCity] [varchar](50) NOT NULL,
        [ProviderState] [varchar](50) NOT NULL, 
        [ProviderZip] [varchar](15) NOT NULL,
	[ProviderPhone] [varchar](25) NULL,
PRIMARY KEY (DisclosureId)
) 
END
GO


IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_DisclosureNature'  )
    BEGIN
CREATE TABLE [App].[NVCC_DisclosureNature](
	[DisclosureId] [int] NOT NULL,
	[NatureId] [int] NOT NULL,
PRIMARY KEY (DisclosureId,NatureId),
CONSTRAINT  FK_DisclosureNature_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE,
CONSTRAINT  FK_DisclosureNature_Nature FOREIGN KEY(NatureId)REFERENCES [App].[NVCC_Nature](NatureId) ON DELETE CASCADE
) 
END
GO

IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLES T
        WHERE T.TABLE_SCHEMA = 'App'
        AND T.TABLE_NAME = 'NVCC_AdditionalObject'  )
    BEGIN
CREATE TABLE [App].[NVCC_AdditionalObject](
	[AdditionalObjectId] [Bigint] IDENTITY(1,1) NOT NULL,
	[DisclosureId] [int] NOT NULL,
    [DateOfObject] [datetime2](2) NULL,
	[ObjectType] [varchar](50) NOT NULL,
	[OtherTypeText] [varchar](130) NULL,
PRIMARY KEY (AdditionalObjectId),
CONSTRAINT  FK_AdditionalObject_Disclosure FOREIGN KEY(DisclosureId) REFERENCES [App].[NVCC_Disclosure](DisclosureId) ON DELETE CASCADE
) 
END
GO